package com.qboxus.tictic.activitesfragments.shoping.AddProducts

import android.content.Intent
import android.content.pm.ServiceInfo
import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.text.TextUtils
import android.util.Log
import android.view.View
import android.widget.Toast
import androidx.activity.result.ActivityResult
import androidx.activity.result.contract.ActivityResultContracts
import androidx.activity.result.contract.ActivityResultContracts.StartActivityForResult
import androidx.appcompat.app.AppCompatActivity
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.ItemTouchHelper
import androidx.recyclerview.widget.LinearLayoutManager
import com.qboxus.tictic.Constants
import com.qboxus.tictic.R
import com.qboxus.tictic.activitesfragments.shoping.GalleryActivity
import com.qboxus.tictic.activitesfragments.shoping.Utils.ItemMoveCallback
import com.qboxus.tictic.activitesfragments.shoping.Utils.PhotoViewHolder
import com.qboxus.tictic.activitesfragments.shoping.adapter.SelectedImagesAdapter
import com.qboxus.tictic.activitesfragments.shoping.models.AddProductModel
import com.qboxus.tictic.activitesfragments.shoping.models.CategoryModel
import com.qboxus.tictic.activitesfragments.shoping.models.GalleryModel
import com.qboxus.tictic.activitesfragments.shoping.services.ProductImagesService
import com.qboxus.tictic.apiclasses.ApiLinks
import com.qboxus.tictic.databinding.ActivityAddDetailsBinding
import com.qboxus.tictic.interfaces.FragmentCallBack
import com.qboxus.tictic.mainmenu.MainMenuActivity
import com.qboxus.tictic.simpleclasses.DataParsing
import com.qboxus.tictic.simpleclasses.Dialogs
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import com.volley.plus.VPackages.VolleyRequest
import org.json.JSONObject
import java.util.Collections

class AddDetailsA : AppCompatActivity(), View.OnClickListener, ItemMoveCallback.ItemTouchHelperContract{
    var binding:ActivityAddDetailsBinding?=null
    var dataModel: AddProductModel?=null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding=DataBindingUtil.setContentView(this,R.layout.activity_add_details)
        setContentView(binding!!.root)

        if(intent!=null) {
            dataModel = intent.getParcelableExtra<AddProductModel>("dataModel")!!
            setUpData()
        }

        setSelectedImagesAdapter()

        binding!!.selectCategoryLayout.setOnClickListener(this)
        binding!!.conditionLayout.setOnClickListener(this)
        binding!!.detailLayout.setOnClickListener(this)
        binding!!.dealMethodLayout.setOnClickListener(this)
        binding!!.priceLayout.setOnClickListener(this)
        binding!!.addBtn.setOnClickListener(this)
        binding!!.ivBack.setOnClickListener(this)

    }



    var productImagesAdapter:SelectedImagesAdapter?=null
    fun setSelectedImagesAdapter() {


        productImagesAdapter = SelectedImagesAdapter(
            this, dataModel!!.imagesList
        ) { view, pos, `object` ->
            when (view.id) {
                R.id.mainLayout -> {
                    if(`object`==null){
                        selectImage()
                    }
                }
                R.id.deleteImageBtn -> {
                    dataModel!!.imagesList.removeAt(pos)
                    productImagesAdapter!!.notifyDataSetChanged()
                }
            }
        }
        val linearLayoutManager = LinearLayoutManager(this, LinearLayoutManager.HORIZONTAL, false)
        binding!!.imagesRecylerView.setLayoutManager(linearLayoutManager)
        binding!!.imagesRecylerView.setAdapter(productImagesAdapter)

        val callback: ItemTouchHelper.Callback = ItemMoveCallback(this)
        val touchHelper = ItemTouchHelper(callback)
        touchHelper.attachToRecyclerView(binding!!.imagesRecylerView)
    }

    fun selectImage(){
        val intent=Intent(this, GalleryActivity::class.java)
        intent.putExtra("dataModel",dataModel)
        resultCallback.launch(intent)
    }



    var resultCallback = registerForActivityResult(
        ActivityResultContracts.StartActivityForResult()
    ) { result ->
        if (result.resultCode == RESULT_OK) {
            val data = result.data

            val seletedList=data!!.getSerializableExtra("data") as ArrayList<GalleryModel>

            val selectedImages = ArrayList<Uri?>()

            if (seletedList != null) {
                for (model in seletedList) {
                    selectedImages.add(Uri.parse(model.actualUri))
                    Functions.printLog(Constants.tag, "Uri: $model.actualUri")
                }
            }

            if(selectedImages.size<10){
                selectedImages.add(null)
            }

            dataModel!!.imagesList.clear()
            dataModel!!.imagesList.addAll(selectedImages)
            productImagesAdapter!!.notifyDataSetChanged()

        }
    }



    override fun onClick(v: View?) {


        if(v!!.id==R.id.conditionLayout){
            val intent=Intent(this@AddDetailsA,AddProductConditionA::class.java)
            intent.putExtra("dataModel",dataModel)
            luncher.launch(intent)
        }

        else if(v!!.id==R.id.detailLayout){
            val intent=Intent(this@AddDetailsA,AddProductDetailsA::class.java)
            intent.putExtra("dataModel",dataModel)
            luncher.launch(intent)

        }

        else if(v!!.id==R.id.dealMethodLayout){

            val intent=Intent(this@AddDetailsA,DealMethodA::class.java)
            intent.putExtra("dataModel",dataModel)
            luncher.launch(intent)

        }

        else if(v!!.id==R.id.priceLayout){
            val intent=Intent(this@AddDetailsA,AddPriceA::class.java)
            intent.putExtra("dataModel",dataModel)
            luncher.launch(intent)
        }

        else if(v!!.id==R.id.selectCategoryLayout){
            getAllCategory()
        }


        else if(v!!.id==R.id.addBtn){
            if(checkValidation()){
                callApiAddProduct()
            }
        }
        else if(v!!.id==R.id.iv_back){
            finish()
        }



    }


    var luncher = registerForActivityResult<Intent, ActivityResult>(
        StartActivityForResult()
    ) { result ->
        if (result.resultCode == RESULT_OK) {
            val data = result.data
            data.let {
                dataModel = it?.getParcelableExtra<AddProductModel>("dataModel")

                setUpData()
            }
        }
    }


    fun setUpData(){

        binding!!.categoryTxt.setText(dataModel!!.categoryModel!!.title)

        if(!TextUtils.isEmpty(dataModel!!.condition)) {
            binding!!.conditionTxt.text = dataModel!!.condition
        }

        if(!TextUtils.isEmpty(dataModel!!.title)) {
            binding!!.detailTxt.text = dataModel!!.title
        }

        if(!TextUtils.isEmpty(dataModel!!.dealMethod)) {
            binding!!.dealMethodTxt.text = dataModel!!.dealMethod
        }

        if(!TextUtils.isEmpty(dataModel!!.price)) {
            binding!!.PriceTxt.text = "${Constants.CURRENCY} ${dataModel!!.price}"
        }

    }




    fun getAllCategory() {

        val parameters = JSONObject()
        try {
            parameters.put("parent_id", "0")

        } catch (e: Exception) {
            e.printStackTrace()
        }
        Functions.showLoader(this, false, false)
        VolleyRequest.JsonPostRequest(
            this,
            ApiLinks.showProductCategories,
            parameters,
            Functions.getHeaders(this)
        ) { resp ->
            Functions.checkStatus(this, resp)
            Functions.cancelLoader()

            try {
                val response = JSONObject(resp)
                val code = response.optString("code")
                if (code == "200") {
                    val msgArray = response.getJSONArray("msg")

                    val temp_list = java.util.ArrayList<CategoryModel>()
                    for (i in 0 until msgArray.length()) {
                        val itemdata = msgArray.optJSONObject(i)
                        val Category = itemdata.optJSONObject("Category")

                        var model= DataParsing.getCategoryDataModel(Category)

                        val Children = itemdata.optJSONArray("Children")
                        val childList = java.util.ArrayList<CategoryModel>()
                        if (Children!=null && Children.length()>0) {
                            for (j in 0 until Children.length()) {
                                val jsonObject = Children.getJSONObject(j)
                                var model= DataParsing.getCategoryDataModel(jsonObject)
                                childList.add(model)
                            }
                        }

                        model.list=childList
                        temp_list.add(model)

                    }

                  openSubCat(temp_list, getString(R.string.select_category))
                }

            } catch (e: Exception) {
                Log.d(Constants.tag, "Exception: comment$e")
            }
        }
    }


    private fun openSubCat(dataList: ArrayList<CategoryModel>,title:String) {
        val fragment = SubCategoryF.newInstance(dataList, title,object: FragmentCallBack {
            override fun onResponce(bundle: Bundle?) {
                val categoryModel=bundle!!.getParcelable<CategoryModel>("data")
                if(categoryModel!!.list!=null && categoryModel!!.list.size>0){
                    openSubCat(categoryModel.list,categoryModel?.title!!.toString())
                }
                else {
                    dataModel!!.categoryModel = bundle!!.getParcelable<CategoryModel>("data")
                    setUpData()
                }

            }
        })
        fragment.show(getSupportFragmentManager(), "SubCategoryF")
    }



    fun checkValidation():Boolean{
        if(TextUtils.isEmpty(dataModel!!.condition)) {
            Functions.showToast(this, getString(R.string.please_select_the_condition_of_product))
            return false
        }

        if(TextUtils.isEmpty(dataModel!!.title)) {
            Functions.showToast(this, getString(R.string.please_enter_product_details))
            return false
        }

        if(TextUtils.isEmpty(dataModel!!.dealMethod)) {
            Functions.showToast(this, getString(R.string.please_select_where_you_deal_this_product))
            return false
        }

        if(TextUtils.isEmpty(dataModel!!.price)) {
            Functions.showToast(this, getString(R.string.please_enter_product_price))
            return false
        }

        return true
    }

    fun callApiAddProduct() {

        val parameters = JSONObject()
        try {

            parameters.put("user_id", Functions.getSharedPreference(this).getString(Variables.U_ID, ""))
            parameters.put("category_id", dataModel!!.categoryModel!!.id)
            parameters.put("title", dataModel!!.title)
            parameters.put("description", dataModel!!.description)
            parameters.put("price", dataModel!!.price)
            parameters.put("condition", Functions.replaceSpecialCharactersWithUnderscore(dataModel!!.condition))
            parameters.put("delivery_method", dataModel!!.dealMethod)
            if(dataModel!!.dealMethod.equals("meetup")){
                parameters.put("meetup_location_string",dataModel!!.locationString)
                parameters.put("meetup_location_lat", dataModel!!.lat)
                parameters.put("meetup_location_long", dataModel!!.lng)
            }

        } catch (e: Exception) {
            e.printStackTrace()
        }

         Functions.showLoader(this, false, false)
        VolleyRequest.JsonPostRequest(
            this,
            ApiLinks.addProduct,
            parameters,
            Functions.getHeaders(this)
        ) { resp ->
            Functions.checkStatus(this, resp)
            Functions.cancelLoader()
            try {
                val response = JSONObject(resp)
                val code = response.optString("code")
                if (code == "200") {
                    val msg = response.optJSONObject("msg")
                    val Product=msg.optJSONObject("Product");
                    dataModel!!.id=Product.optString("id")
                    if(dataModel!!.imagesList.size>0){
                        startService()
                    }

                }

            } catch (e: Exception) {
                Log.d(Constants.tag, "Exception: comment$e")
                Functions.cancelLoader()
            }
        }
    }


    fun startService() {
        val mService = ProductImagesService()
        if (!Functions.isMyServiceRunning(this, mService.javaClass)) {

            val mServiceIntent = Intent(this.applicationContext, mService.javaClass)
            mServiceIntent.setAction("startservice")
            mServiceIntent.putExtra("dataModel", dataModel)
            startService(mServiceIntent)


            this@AddDetailsA.runOnUiThread(Runnable {
                val intent = Intent(this@AddDetailsA, MainMenuActivity::class.java)
                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK or Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TOP)
                startActivity(intent)
               })
        }
        else {
            Toast.makeText(
                this@AddDetailsA,
                getString(R.string.please_wait_product_uploading_is_already_in_progress),
                Toast.LENGTH_SHORT
            ).show()
        }
    }


    override fun onRowMoved(fromPosition: Int, toPosition: Int) {
        Functions.printLog(Constants.tag,"fromPosition: $fromPosition ToPosition: $toPosition")
        if (dataModel!!.imagesList.get(fromPosition)==null) {
        } else {
            if (fromPosition < toPosition) {
                for (i in fromPosition until toPosition) {
                    Collections.swap(dataModel!!.imagesList, i, i + 1)
                }
            } else {
                for (i in fromPosition downTo toPosition + 1) {
                    Collections.swap(dataModel!!.imagesList, i, i - 1)
                }
            }
            productImagesAdapter!!.notifyItemMoved(fromPosition, toPosition)
        }
    }

    override fun onRowSelected(myViewHolder: PhotoViewHolder?) {
        Functions.printLog(Constants.tag,"onRowSelected")
    }

    override fun onRowClear(myViewHolder: PhotoViewHolder?) {
        Functions.printLog(Constants.tag,"onRowClear")
    }



}